﻿/*
 * SettingFastPWM.h
 *
 * Created: 2014/06/07 23:33:40
 *  Author: Hirosi
 */ 


#ifndef SETTINGFASTPWM_H_
#define SETTINGFASTPWM_H_

/* タイマ/カウンタ0制御レジスタ設定 データシート64ページ参照 */
#define Set_WGM0	3	//	波形生成種別選択
						// 0 : 標準動作
						// 1 : 8ビット位相基準PWM動作
						// 2 : 比較一致タイマ/カウンタクリア(CTC)動作
						// 3 : 8ビット高速PWM動作
						// 4 : (予約)
						// 5 : 位相基準PWM動作
						// 6 : (予約)
						// 7 : 高速PWM動作

#define Set_COM0A	2	//	高速PWM動作比較A出力選択
						// 0 : 標準ポート動作(OC0A切断)
						// 1 : WGM0の2ビット目が0なら標準ポート動作、1なら比較一致で
						//		OC0Aピントグル出力
						// 2 : 比較一致でLow、BOTTOMでHighをOC0Aピンへ出力(非反転動作)
						// 3 : 比較一致でHigh、BOTTOMでLowをOC0Aピンへ出力(反転動作)
						
#define Set_COM0B	0	//	高速PWM動作比較B出力選択
						// 0 : 標準ポート動作(OC0B切断)
						// 1 : 予約
						// 2 : 比較一致でLow、BOTTOMでHighをOC0Bピンへ出力(非反転動作)
						// 3 : 比較一致でHigh、BOTTOMでLowをOC0Bピンへ出力(反転動作)

#define Set_CS0		1	//	タイマ/カウンタ0入力クロック選択
						// 0 : 停止 (ﾀｲﾏ/ｶｳﾝﾀ0動作停止
						// 1 : clkI/O(前置分周なし)
						// 2 : clkI/O/8 (8分周)
						// 3 : clkI/O/64 (64分周)
						// 4 : clkI/O/256 (256分周)
						// 5 : clkI/O/1024 (1024分周)
						// 6 : T0ﾋﾟﾝの立ち下りｴｯｼﾞ (外部ｸﾛｯｸ)
						// 7 : T0ﾋﾟﾝの立ち上りｴｯｼﾞ (外部ｸﾛｯｸ)
						
					
/* タイマ/カウンタ2制御レジスタ設定 データシート99ページ参照 */
#define Set_WGM2	3	//	波形生成種別選択
						// 0 : 標準動作
						// 1 : 8ビット位相基準PWM動作
						// 2 : 比較一致タイマ/カウンタクリア(CTC)動作
						// 3 : 8ビット高速PWM動作
						// 4 : (予約)
						// 5 : 位相基準PWM動作
						// 6 : (予約)
						// 7 : 高速PWM動作

#define Set_COM2A	2	//	高速PWM動作比較A出力選択
						// 0 : 標準ポート動作(OC2A切断)
						// 1 : WGM2の2ビット目が0なら標準ポート動作、1なら比較一致で
						//		OC2Aピントグル出力
						// 2 : 比較一致でLow、BOTTOMでHighをOC2Aピンへ出力(非反転動作)
						// 3 : 比較一致でHigh、BOTTOMでLowをOC2Aピンへ出力(反転動作)

#define Set_COM2B	0	//	高速PWM動作比較B出力選択
						// 0 : 標準ポート動作(OC2B切断)
						// 1 : 予約
						// 2 : 比較一致でLow、BOTTOMでHighをOC2Bピンへ出力(非反転動作)
						// 3 : 比較一致でHigh、BOTTOMでLowをOC2Bピンへ出力(反転動作)

#define Set_CS2		1	//	タイマ/カウンタ2入力クロック選択
						// 0 : 停止 (ﾀｲﾏ/ｶｳﾝﾀ2動作停止)
						// 1 : clkT2S (前置分周なし)
						// 2 : clkT2S/8 (8分周)
						// 3 : clkT2S/32 (32分周)
						// 4 : clkT2S/64 (64分周)
						// 5 : clkT2S/128 (128分周)
						// 6 : clkT2S/256 (256分周)
						// 7 : clkT2S/1024 (1024分周)
						

//////////////////////////////////////////////////////////////////
//ここから下は触らないでください
//////////////////////////////////////////////////////////////////
//プロトタイプ宣言
void FastPWMStart();	//高速PWMを開始する


// I/O設定
#define OC0A_DDR DDRD
#define OCR0A_Num 6
#define OC0B_DDR DDRD
#define OCR0B_Num 5
#define OC2A_DDR DDRB
#define OCR2A_Num 3
#define OC2B_DDR DDRD
#define OCR2B_Num 3



#endif /* SETTINGFASTPWM_H_ */